#!/usr/bin/env python
# -*- coding: utf-8 -*-
from livewires import *
import random

class agent :
	def __init__(self,x,y,size,color) :
		self.size_x = size_x
		self.size_y = size_y
		self.k = k
		posx = (x+0.5)*k
		posy = (y+0.5)*k
		print posx,posy
		self.me = circle(posx,posy,size,filled=color)
		self.x = posx
		self.y = posy
		self.do_move()

	def coord(self) :
		return [self.x,self.y]
	
	def move(self, mv) :
		if mv == 1 :
			self.up()
		elif mv == 2 :
			self.right()
		elif mv == 3 :
			self.bottom()
		elif mv == 4 :
			self.left()
		else :
			self.do_move()

	def left(self) :
		self.x = self.x - self.k
		self.do_move()
	
	def right(self) :
		self.x = self.x + self.k
		self.do_move()	

	def up(self) :
		self.y = self.y + self.k
		self.do_move()	

	def bottom(self) :
		self.y = self.y - self.k
		self.do_move()	

	def do_move(self):
		if self.x >= self.size_x :
		    self.x = self.x - self.size_x
		if self.y >= self.size_y :
		    self.y = self.y - self.size_y
		if self.x < 0 :
		    self.x = self.x + self.size_x
		if self.y < 0 :
		    self.y = self.y + self.size_y
		move_to(self.me, self.x, self.y)

class environnement :
	def __init__(self,agents, objectif) :
		self.agents=agents
		self.obj = objectif
		self.size_x = size_x
		self.size_y = size_y
		self.k = k
	
	def goal(self):
		goal = 0
		for i in self.agents :
			if i.coord()[0] == self.obj.coord()[0] and i.coord()[1] == self.obj.coord()[1] :
				goal = 1
		return goal

	def value_agent(self,agent) :
		tmp = self.distance(agent.coord(),self.obj.coord())
		return 0-tmp

	def reward(self,agent):
		if self.goal() == 1 :
			return 10000
		else :
			return self.value_agent(agent)

	def exp_return(self,a,depth) :
		max_depth = 1
		if depth > max_depth :
			return self.reward(a)
		d = depth+1
		gamma = .1
		move = 0
		value = self.exp_return(a,d)
		a.right()
		right = self.exp_return(a,d)
		a.left()
		if right > value :
			move = 2
			value = right
		a.left()
		left = self.exp_return(a,d)
		a.right()
		if left > value :
			move = 4
			value = left
		a.up()
		up = self.exp_return(a,d)
		a.bottom()
		if up > value :
			move = 1
			value = up
		a.bottom()
		bot = self.exp_return(a,d)
		a.up()
		if bot > value :
			move = 3
			value = bot
			
		return self.reward(a)+gamma*value
			
		

	def best_move(self,agent) :
		best = 0
		same = 0
		actual = self.exp_return(agent,1)
		agent.up()
		up = self.exp_return(agent,1)
		agent.bottom()
		if up > actual :
			best = 1
			actual = up
		elif up != actual :
			same = 1
		agent.bottom()
		bot = self.exp_return(agent,1)
		agent.up()
		if bot > actual :
			best = 3
			actual = bot
		elif bot != actual :
			same = 1
		agent.left()
		left = self.exp_return(agent,1)
		agent.right()
		if left > actual :
			best = 4
			actual = left
		elif left != actual :
			same = 1
		agent.right()
		right = self.exp_return(agent,1)
		agent.left()
		if right > actual :
			best = 2
			actual = right
		elif right != actual :
			same = 1
		#if same == 0 :
		#	best = random.randint(0,4)
		print  "up: %d -bot: %d -right: %d -left: %d = %d"%(up,bot,right,left,best)
		#print "agent : "+agent.coord()
		#print "obj :"+self.obj.coord()
		return best
		

	def distance(self,a,b) :
		k_x = self.size_x
		k_y = self.size_y
		distance = 0
		### X###
		if a[0] < b[0] :
			horiz1 = b[0] - a[0]
			horiz2 = k_x - b[0] + a[0]
			if horiz1 < horiz2 :
				distance += horiz1
			else :
				distance += horiz2
		elif a[0] > b[0] :
			horiz1 = a[0] - b[0]
			horiz2 = k_x - a[0] + b[0]
			if horiz1 < horiz2 :
				distance += horiz1
			else :
				distance += horiz2
		### y ####
		if a[1] < b[1] :
			horiz1 = b[1] - a[1]
			horiz2 = k_y - b[1] + a[1]
			if horiz1 < horiz2 :
				distance += horiz1
			else :
				distance += horiz2
		elif a[1] > b[1] :
			horiz1 = a[1] - b[1]
			horiz2 = k_y - a[1] + b[1]
			if horiz1 < horiz2 :
				distance += horiz1
			else :
				distance += horiz2
		return distance
		

if __name__ == "__main__":
	global size_x, size_y, k
	size_x = 200
	size_y = 200
	k = 20
	begin_graphics(width=size_x, height=size_y)
	i = 0
	while i <= size_x :
		j=0
		while j <= size_y :
			box(i,j,i+k-1,j+k-1)
			j += k
		i += k
	allow_moveables()
	cat1 = agent(5,4,k*0.4,1)
	mouse = agent(0,0,k*0.4,0)
	env = environnement([cat1],mouse)
	i = 10
	moves = 0
	time.sleep(1)
	while env.goal() == 0 :
		mouse.move(random.randint(0,4))
		time.sleep(0.5)
		cat1.move(env.best_move(cat1))
		moves += 1
		#print "@@@@@@@"
		#print i
		#print "@@@@@@@"
		#cat1.right()
		#time.sleep(0.5)
		#mouse.left()
		#time.sleep(0.5)
		#cat1.bottom()
		#time.sleep(0.5)
		#mouse.up()
		#i += 1
		#print "@@@@@@@@@@"
		#print env.value_agent(cat1)
		time.sleep(0.5)
	end_graphics()
	print "%d mouvements pour attraper la souris" %moves
