#!/usr/bin/env python
# -*- coding: utf-8 -*-
from livewires import *
from Numeric import *
from ml_envir import *
import random

class agent :
	def __init__(self, objet,size,position,env) :
		self.agents = []
		self.env = env
		self.name = objet.name
		self.size_x = size[0]
		self.size_y = size[1]
		for i in position :
			self.agents.append(single_agent(i, self.name, self.env,self.size_x,self.size_y))
		self.me = objet

	def reinit(self) :
		for i in self.agents :
			i.reinit()

	def do_action(self,i) :
		return self.me.action(i,self.agents,self.env)

	def best_move(self) :
		pos = [] 
		b = self.me.find_best_move(self.env,self.agents)
		return self.do_action(b)

	def get_name(self) :
		return self.name
	
	def get_nbr_subagents(self):
		return len(self.agents)

	def get_subagents(self):
		pos = []
		for a in self.agents :
			pos.append(a.get_pos())
		return pos
	
	def get_nbr_actions(self):
		return self.me.nbr_actions()

	def get_nbr_states(self):
		tot = 0
		for a in self.agents :
			tot += self.me.nbr_actions()
		return tot

	


class single_agent :

	def __init__(self, position,name, env,size_x,size_y) :
		self.init = position
		self.x = position[0]
		self.y = position[1]
		self.oldx = position[0]
		self.oldy = position[1]
		self.env = env
		self.name = name
		self.k = 1
		self.size_x = size_x
		self.size_y = size_y

	def reinit(self) :
		self.x = self.init[0]
		self.y = self.init[1]
		self.oldx = self.init[0]
		self.oldy = self.init[1]

	def get_pos(self) :
		return [self.x,self.y]

	def test(self,mv) :
		t = self.move(mv)
		if t == 0 :
			self.back(mv)
		return t

	def move(self, mv) :
		self.old_x = self.x
		self.old_y = self.y
		if mv == 1 :
			return self.up()
		elif mv == 2 :
			return self.right()
		elif mv == 3 :
			return self.bottom()
		elif mv == 4 :
			return self.left()
		else :
			return self.do_move()

	def back(self, mv) :
		self.old_x = self.x
		self.old_y = self.y
		if mv == 3 :
			return self.up()
		elif mv == 4 :
			return self.right()
		elif mv == 1 :
			return self.bottom()
		elif mv == 2 :
			return self.left()
		else :
			return self.do_move()

	def left(self) :
		self.x = self.x - self.k
		return self.do_move()
	
	def right(self) :
		self.x = self.x + self.k
		return self.do_move()	

	def up(self) :
		self.y = self.y + self.k
		return self.do_move()	

	def bottom(self) :
		self.y = self.y - self.k
		return self.do_move()	

	def do_move(self):
		if self.x >= self.size_x :
		    self.x = self.x - self.size_x
		if self.y >= self.size_y :
		    self.y = self.y - self.size_y
		if self.x < 0 :
		    self.x = self.x + self.size_x
		if self.y < 0 :
		    self.y = self.y + self.size_y
		
		target = self.env.get([self.x,self.y])
		#print "target = %s"%str(target)
		if target == 0 :
			self.env.remove([self.old_x,self.old_y])
			self.env.put(self.name,[self.x,self.y])
			return 0
		elif self.x == self.old_x and self.y == self.old_y :
			return 0
		else :
			self.x = self.old_x
			self.y = self.old_y
			return target
		# visualisation
		#move_to(self.me, self.x, self.y)
	

